/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.core;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Interpolation;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.AnimationStateData;
import com.esotericsoftware.spine.Skeleton;
import com.esotericsoftware.spine.SkeletonData;
import com.esotericsoftware.spine.SkeletonJson;
import com.esotericsoftware.spine.SkeletonMeshRenderer;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.helpers.TipHelper;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.TextAboveCreatureEffect;
import com.megacrit.cardcrawl.vfx.TintEffect;
import com.megacrit.cardcrawl.vfx.combat.BlockImpactLineEffect;
import com.megacrit.cardcrawl.vfx.combat.BlockedNumberEffect;
import com.megacrit.cardcrawl.vfx.combat.BlockedWordEffect;
import com.megacrit.cardcrawl.vfx.combat.HbBlockBrokenEffect;
import com.megacrit.cardcrawl.vfx.combat.HealEffect;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCreature {
    private static final Logger logger = LogManager.getLogger(AbstractCreature.class.getName());
    public String name;
    public String title;
    public String id;
    public ArrayList<AbstractPower> powers = new ArrayList();
    public boolean isPlayer;
    public boolean isBloodied;
    public float drawX;
    public float drawY;
    public float dialogX;
    public float dialogY;
    public Hitbox hb;
    public int gold;
    public int displayGold;
    public static final int DAMAGE_FLASH_FRAMES = 4;
    public boolean damageFlash = false;
    public int damageFlashFrames;
    public boolean isDying = false;
    public boolean isDead = false;
    public boolean halfDead = false;
    protected static final float TIP_X_THRESHOLD = 1544.0f * Settings.scale;
    protected static final float MULTI_TIP_Y_OFFSET = 80.0f * Settings.scale;
    protected static final float TIP_OFFSET_R_X = 20.0f * Settings.scale;
    protected static final float TIP_OFFSET_L_X = -380.0f * Settings.scale;
    protected static final float TIP_OFFSET_Y = 80.0f * Settings.scale;
    private static UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("AbstractCreature");
    public static final String[] TEXT = AbstractCreature.uiStrings.TEXT;
    public Hitbox healthHb;
    private float healthHideTimer = 0.0f;
    protected float hb_x;
    protected float hb_y;
    protected float hb_w;
    protected float hb_h;
    public int currentHealth;
    public int maxHealth;
    public int currentBlock;
    private float healthBarWidth;
    private float targetHealthBarWidth;
    private float hbShowTimer = 0.0f;
    private float healthBarAnimTimer = 0.0f;
    private float blockAnimTimer = 0.0f;
    private float blockOffset = 0.0f;
    private float blockScale = 1.0f;
    public float hbAlpha = 0.0f;
    private float hbYOffset = HB_Y_OFFSET_DIST * 5.0f;
    private Color hbBgColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color hbShadowColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color blockColor = new Color(0.6f, 0.93f, 0.98f, 0.0f);
    private Color blockOutlineColor = new Color(0.6f, 0.93f, 0.98f, 0.0f);
    private Color blockTextColor = new Color(0.9f, 0.9f, 0.9f, 0.0f);
    private Color redHbBarColor = new Color(0.8f, 0.05f, 0.05f, 0.0f);
    private Color greenHbBarColor = Color.valueOf("78c13c00");
    private Color blueHbBarColor = Color.valueOf("31568c00");
    private Color orangeHbBarColor = new Color(1.0f, 0.5f, 0.0f, 0.0f);
    private Color hbTextColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private static final float BLOCK_ANIM_TIME = 0.7f;
    private static final float BLOCK_OFFSET_DIST = 12.0f * Settings.scale;
    private static final float SHOW_HB_TIME = 0.7f;
    private static final float HB_Y_OFFSET_DIST = 12.0f * Settings.scale;
    protected static final float BLOCK_ICON_X = -14.0f * Settings.scale;
    protected static final float BLOCK_ICON_Y = -14.0f * Settings.scale;
    private static final int BLOCK_W = 64;
    private static final float HEALTH_BAR_PAUSE_DURATION = 1.2f;
    private static final float HEALTH_BAR_HEIGHT = 20.0f * Settings.scale;
    private static final float HEALTH_BAR_OFFSET_Y = -28.0f * Settings.scale;
    private static final float HEALTH_TEXT_OFFSET_Y = 6.0f * Settings.scale;
    private static final float POWER_ICON_PADDING_X = 48.0f * Settings.scale;
    private static final float HEALTH_BG_OFFSET_X = 31.0f * Settings.scale;
    public TintEffect tint = new TintEffect();
    public static SkeletonMeshRenderer sr;
    private boolean shakeToggle = true;
    private static final float SHAKE_THRESHOLD;
    private static final float SHAKE_SPEED;
    public float animX;
    public float animY;
    protected float vX;
    protected float vY;
    protected CreatureAnimation animation;
    protected float animationTimer = 0.0f;
    protected static final float SLOW_ATTACK_ANIM_DUR = 1.0f;
    protected static final float STAGGER_ANIM_DUR = 0.3f;
    protected static final float FAST_ATTACK_ANIM_DUR = 0.4f;
    protected static final float HOP_ANIM_DURATION = 0.7f;
    private static final float STAGGER_MOVE_SPEED;
    protected TextureAtlas atlas = null;
    protected Skeleton skeleton;
    public AnimationState state;
    protected AnimationStateData stateData;
    private static final int RETICLE_W = 36;
    public float reticleAlpha = 0.0f;
    public boolean reticleRendered = false;
    private float reticleOffset = 0.0f;
    private float reticleAnimTimer = 0.0f;
    private static final float RETICLE_OFFSET_DIST;

    public abstract void damage(DamageInfo var1);

    protected int decrementBlock(DamageInfo info, int damageAmount) {
        if (info.type != DamageInfo.DamageType.HP_LOSS && this.currentBlock > 0) {
            CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.MED, ScreenShake.ShakeDur.SHORT, false);
            if (damageAmount > this.currentBlock) {
                CardCrawlGame.sound.play("BLOCK_BREAK");
                damageAmount -= this.currentBlock;
                if (Settings.SHOW_DMG_BLOCK) {
                    AbstractDungeon.effectList.add(new BlockedNumberEffect(this.hb.cX, this.hb.cY + this.hb.height / 2.0f, Integer.toString(this.currentBlock)));
                }
                this.loseBlock();
                AbstractDungeon.effectList.add(new HbBlockBrokenEffect(this.hb.cX - this.hb.width / 2.0f + BLOCK_ICON_X, this.hb.cY - this.hb.height / 2.0f + BLOCK_ICON_Y));
            } else if (damageAmount == this.currentBlock) {
                damageAmount = 0;
                this.loseBlock();
                AbstractDungeon.effectList.add(new HbBlockBrokenEffect(this.hb.cX - this.hb.width / 2.0f + BLOCK_ICON_X, this.hb.cY - this.hb.height / 2.0f + BLOCK_ICON_Y));
                CardCrawlGame.sound.play("BLOCK_BREAK");
                AbstractDungeon.effectList.add(new BlockedWordEffect(this, this.hb.cX, this.hb.cY, TEXT[1]));
            } else {
                CardCrawlGame.sound.play("BLOCK_ATTACK");
                this.loseBlock(damageAmount);
                for (int i = 0; i < 18; ++i) {
                    AbstractDungeon.effectList.add(new BlockImpactLineEffect(this.hb.cX, this.hb.cY));
                }
                if (Settings.SHOW_DMG_BLOCK) {
                    AbstractDungeon.effectList.add(new BlockedNumberEffect(this.hb.cX, this.hb.cY + this.hb.height / 2.0f, Integer.toString(damageAmount)));
                }
                damageAmount = 0;
            }
        }
        return damageAmount;
    }

    public void increaseMaxHp(int amount, boolean showEffect) {
        if (amount < 0) {
            logger.info("Why are we decreasing health with increaseMaxHealth()?");
        }
        this.maxHealth += amount;
        AbstractDungeon.effectsQueue.add(new TextAboveCreatureEffect(this.hb.cX - this.animX, this.hb.cY, TEXT[2] + Integer.toString(amount), Settings.GREEN_TEXT_COLOR));
        this.heal(amount, true);
        this.healthBarUpdatedEvent();
    }

    public void decreaseMaxHealth(int amount) {
        if (amount < 0) {
            logger.info("Why are we increasing health with decreaseMaxHealth()?");
        }
        this.maxHealth -= amount;
        if (this.currentHealth > this.maxHealth) {
            this.currentHealth = this.maxHealth;
        }
        this.healthBarUpdatedEvent();
    }

    protected void refreshHitboxLocation() {
        this.hb.move(this.drawX + this.hb_x + this.animX, this.drawY + this.hb_y + this.hb_h / 2.0f);
        this.healthHb.move(this.hb.cX, this.hb.cY - this.hb_h / 2.0f - this.healthHb.height / 2.0f);
    }

    public void updateAnimations() {
        if (this.animationTimer != 0.0f) {
            switch (this.animation) {
                case ATTACK_FAST: {
                    this.updateFastAttackAnimation();
                    break;
                }
                case ATTACK_SLOW: {
                    this.updateSlowAttackAnimation();
                    break;
                }
                case FAST_SHAKE: {
                    this.updateFastShakeAnimation();
                    break;
                }
                case HOP: {
                    this.updateHopAnimation();
                    break;
                }
                case JUMP: {
                    this.updateJumpAnimation();
                    break;
                }
                case SHAKE: {
                    this.updateShakeAnimation();
                    break;
                }
                case STAGGER: {
                    this.updateStaggerAnimation();
                    break;
                }
            }
        }
        this.refreshHitboxLocation();
        if (!this.isPlayer) {
            ((AbstractMonster)this).refreshIntentHbLocation();
        }
    }

    protected void updateFastAttackAnimation() {
        this.animationTimer -= Gdx.graphics.getDeltaTime();
        float targetPos = 90.0f * Settings.scale;
        if (!this.isPlayer) {
            targetPos = -targetPos;
        }
        if (this.animationTimer > 0.5f) {
            this.animX = Interpolation.exp5In.apply(0.0f, targetPos, (1.0f - this.animationTimer / 1.0f) * 2.0f);
        } else if (this.animationTimer < 0.0f) {
            this.animationTimer = 0.0f;
            this.animX = 0.0f;
        } else {
            this.animX = Interpolation.fade.apply(0.0f, targetPos, this.animationTimer / 1.0f * 2.0f);
        }
    }

    protected void updateSlowAttackAnimation() {
        this.animationTimer -= Gdx.graphics.getDeltaTime();
        float targetPos = 90.0f * Settings.scale;
        if (!this.isPlayer) {
            targetPos = -targetPos;
        }
        if (this.animationTimer > 0.5f) {
            this.animX = Interpolation.exp10In.apply(0.0f, targetPos, (1.0f - this.animationTimer / 1.0f) * 2.0f);
        } else if (this.animationTimer < 0.0f) {
            this.animationTimer = 0.0f;
            this.animX = 0.0f;
        } else {
            this.animX = Interpolation.fade.apply(0.0f, targetPos, this.animationTimer / 1.0f * 2.0f);
        }
    }

    protected void updateFastShakeAnimation() {
        this.animationTimer -= Gdx.graphics.getDeltaTime();
        if (this.animationTimer < 0.0f) {
            this.animationTimer = 0.0f;
            this.animX = 0.0f;
        } else if (this.shakeToggle) {
            this.animX += SHAKE_SPEED * Gdx.graphics.getDeltaTime();
            if (this.animX > SHAKE_THRESHOLD / 2.0f) {
                this.shakeToggle = !this.shakeToggle;
            }
        } else {
            this.animX -= SHAKE_SPEED * Gdx.graphics.getDeltaTime();
            if (this.animX < -SHAKE_THRESHOLD / 2.0f) {
                this.shakeToggle = !this.shakeToggle;
            }
        }
    }

    protected void updateHopAnimation() {
        this.vY -= 17.0f * Settings.scale;
        this.animY += this.vY * Gdx.graphics.getDeltaTime();
        if (this.animY < 0.0f) {
            this.animationTimer = 0.0f;
            this.animY = 0.0f;
        }
    }

    protected void updateJumpAnimation() {
        this.vY -= 17.0f * Settings.scale;
        this.animY += this.vY * Gdx.graphics.getDeltaTime();
        if (this.animY < 0.0f) {
            this.animationTimer = 0.0f;
            this.animY = 0.0f;
        }
    }

    protected void updateStaggerAnimation() {
        if (this.animationTimer != 0.0f) {
            this.animationTimer -= Gdx.graphics.getDeltaTime();
            this.animX = !this.isPlayer ? Interpolation.pow2.apply(STAGGER_MOVE_SPEED, 0.0f, 1.0f - this.animationTimer / 0.3f) : Interpolation.pow2.apply(-STAGGER_MOVE_SPEED, 0.0f, 1.0f - this.animationTimer / 0.3f);
            if (this.animationTimer < 0.0f) {
                this.animationTimer = 0.0f;
                this.animX = 0.0f;
                this.vX = STAGGER_MOVE_SPEED;
            }
        }
    }

    protected void updateShakeAnimation() {
        this.animationTimer -= Gdx.graphics.getDeltaTime();
        if (this.animationTimer < 0.0f) {
            this.animationTimer = 0.0f;
            this.animX = 0.0f;
        } else if (this.shakeToggle) {
            this.animX += SHAKE_SPEED * Gdx.graphics.getDeltaTime();
            if (this.animX > SHAKE_THRESHOLD) {
                this.shakeToggle = !this.shakeToggle;
            }
        } else {
            this.animX -= SHAKE_SPEED * Gdx.graphics.getDeltaTime();
            if (this.animX < -SHAKE_THRESHOLD) {
                this.shakeToggle = !this.shakeToggle;
            }
        }
    }

    protected void loadAnimation(String atlasUrl, String skeletonUrl, float scale) {
        this.atlas = new TextureAtlas(Gdx.files.internal(atlasUrl));
        SkeletonJson json = new SkeletonJson(this.atlas);
        json.setScale(Settings.scale / scale);
        SkeletonData skeletonData = json.readSkeletonData(Gdx.files.internal(skeletonUrl));
        this.skeleton = new Skeleton(skeletonData);
        this.skeleton.setColor(Color.WHITE);
        this.stateData = new AnimationStateData(skeletonData);
        this.state = new AnimationState(this.stateData);
    }

    public void heal(int healAmount, boolean showEffect) {
        if (this.isDying) {
            return;
        }
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            if (!this.isPlayer) continue;
            healAmount = r.onPlayerHeal(healAmount);
        }
        for (AbstractPower p : this.powers) {
            healAmount = p.onHeal(healAmount);
        }
        this.currentHealth += healAmount;
        if (this.currentHealth > this.maxHealth) {
            this.currentHealth = this.maxHealth;
        }
        if (healAmount > 0) {
            if (showEffect) {
                AbstractDungeon.effectsQueue.add(new HealEffect(this.hb.cX - this.animX, this.hb.cY, healAmount));
            }
            this.healthBarUpdatedEvent();
        }
    }

    public void heal(int amount) {
        this.heal(amount, true);
    }

    public void addBlock(int blockAmount) {
        if (this.isPlayer) {
            for (AbstractRelic abstractRelic : AbstractDungeon.player.relics) {
                blockAmount = abstractRelic.onPlayerGainBlock(blockAmount);
            }
            if (blockAmount > 0) {
                for (AbstractPower abstractPower : this.powers) {
                    abstractPower.onGainedBlock(blockAmount);
                }
            }
        }
        boolean effect = false;
        if (this.currentBlock == 0) {
            effect = true;
        }
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            for (AbstractPower p : m.powers) {
                blockAmount = p.onPlayerGainedBlock(blockAmount);
            }
        }
        this.currentBlock += blockAmount;
        if (this.currentBlock >= 99 && this.isPlayer) {
            UnlockTracker.unlockAchievement("IMPERVIOUS");
        }
        if (this.currentBlock > 999) {
            this.currentBlock = 999;
        }
        if (this.currentBlock == 999) {
            UnlockTracker.unlockAchievement("BARRICADED");
        }
        if (effect && this.currentBlock > 0) {
            this.gainBlockAnimation();
        } else if (blockAmount > 0 && blockAmount > 0) {
            Color color = Settings.GOLD_COLOR.cpy();
            color.a = this.blockTextColor.a;
            this.blockTextColor = color;
            this.blockScale = 5.0f;
        }
    }

    public void loseBlock(int amount, boolean noAnimation) {
        boolean effect = false;
        if (this.currentBlock != 0) {
            effect = true;
        }
        this.currentBlock -= amount;
        if (this.currentBlock < 0) {
            this.currentBlock = 0;
        }
        if (this.currentBlock == 0 && effect) {
            if (!noAnimation) {
                AbstractDungeon.effectList.add(new HbBlockBrokenEffect(this.hb.cX - this.hb.width / 2.0f + BLOCK_ICON_X, this.hb.cY - this.hb.height / 2.0f + BLOCK_ICON_Y));
            }
        } else if (this.currentBlock > 0 && amount > 0) {
            Color tmp = Color.SCARLET.cpy();
            tmp.a = this.blockTextColor.a;
            this.blockTextColor = tmp;
            this.blockScale = 5.0f;
        }
    }

    public void loseBlock() {
        this.loseBlock(this.currentBlock);
    }

    public void loseBlock(boolean noAnimation) {
        this.loseBlock(this.currentBlock, noAnimation);
    }

    public void loseBlock(int amount) {
        this.loseBlock(amount, false);
    }

    public void showHealthBar() {
        this.hbShowTimer = 0.7f;
        this.hbAlpha = 0.0f;
    }

    public void hideHealthBar() {
        this.hbAlpha = 0.0f;
    }

    public void addPower(AbstractPower powerToApply) {
        boolean hasBuffAlready = false;
        for (AbstractPower p : this.powers) {
            if (!p.ID.equals(powerToApply.ID)) continue;
            p.stackPower(powerToApply.amount);
            p.updateDescription();
            hasBuffAlready = true;
        }
        if (!hasBuffAlready) {
            this.powers.add(powerToApply);
            if (this.isPlayer) {
                int buffCount = 0;
                for (AbstractPower p : this.powers) {
                    if (p.type != AbstractPower.PowerType.BUFF) continue;
                    ++buffCount;
                }
                if (buffCount >= 10) {
                    UnlockTracker.unlockAchievement("POWERFUL");
                }
            }
        }
    }

    public void applyStartOfTurnPowers() {
        for (AbstractPower p : this.powers) {
            p.atStartOfTurn();
        }
    }

    public void applyStartOfTurnPostDrawPowers() {
        for (AbstractPower p : this.powers) {
            p.atStartOfTurnPostDraw();
        }
    }

    public void applyEndOfTurnTriggers() {
        for (AbstractPower p : this.powers) {
            p.atEndOfTurn(this.isPlayer);
        }
    }

    public void healthBarUpdatedEvent() {
        this.healthBarAnimTimer = 1.2f;
        this.targetHealthBarWidth = this.hb.width * (float)this.currentHealth / (float)this.maxHealth;
        if (this.maxHealth == this.currentHealth) {
            this.healthBarWidth = this.targetHealthBarWidth;
        } else if (this.currentHealth == 0) {
            this.healthBarWidth = 0.0f;
            this.targetHealthBarWidth = 0.0f;
        }
        if (this.targetHealthBarWidth > this.healthBarWidth) {
            this.healthBarWidth = this.targetHealthBarWidth;
        }
    }

    public void healthBarRevivedEvent() {
        this.healthBarAnimTimer = 1.2f;
        this.healthBarWidth = this.targetHealthBarWidth = this.hb.width * (float)this.currentHealth / (float)this.maxHealth;
        this.hbBgColor.a = 0.75f;
        this.hbShadowColor.a = 0.5f;
        this.hbTextColor.a = 1.0f;
    }

    protected void updateHealthBar() {
        this.updateHbHoverFade();
        this.updateBlockAnimations();
        this.updateHbPopInAnimation();
        this.updateHbDamageAnimation();
        this.updateHbAlpha();
    }

    private void updateHbHoverFade() {
        if (this.healthHb.hovered) {
            this.healthHideTimer -= Gdx.graphics.getDeltaTime() * 4.0f;
            if (this.healthHideTimer < 0.2f) {
                this.healthHideTimer = 0.2f;
            }
        } else {
            this.healthHideTimer += Gdx.graphics.getDeltaTime() * 4.0f;
            if (this.healthHideTimer > 1.0f) {
                this.healthHideTimer = 1.0f;
            }
        }
    }

    private void updateHbAlpha() {
        if (this instanceof AbstractMonster && ((AbstractMonster)this).isEscaping) {
            this.hbAlpha = MathHelper.fadeLerpSnap(this.hbAlpha, 0.0f);
            this.targetHealthBarWidth = 0.0f;
            this.hbBgColor.a = this.hbAlpha * 0.75f;
            this.hbShadowColor.a = this.hbAlpha * 0.5f;
            this.hbTextColor.a = this.hbAlpha;
            this.orangeHbBarColor.a = this.hbAlpha;
            this.redHbBarColor.a = this.hbAlpha;
            this.greenHbBarColor.a = this.hbAlpha;
            this.blueHbBarColor.a = this.hbAlpha;
            this.blockOutlineColor.a = this.hbAlpha;
        } else if (this.targetHealthBarWidth == 0.0f && this.healthBarAnimTimer <= 0.0f) {
            this.hbShadowColor.a = MathHelper.fadeLerpSnap(this.hbShadowColor.a, 0.0f);
            this.hbBgColor.a = MathHelper.fadeLerpSnap(this.hbBgColor.a, 0.0f);
            this.hbTextColor.a = MathHelper.fadeLerpSnap(this.hbTextColor.a, 0.0f);
            this.blockOutlineColor.a = MathHelper.fadeLerpSnap(this.blockOutlineColor.a, 0.0f);
        } else {
            this.hbBgColor.a = this.hbAlpha * 0.5f;
            this.hbShadowColor.a = this.hbAlpha * 0.2f;
            this.hbTextColor.a = this.hbAlpha;
            this.orangeHbBarColor.a = this.hbAlpha;
            this.redHbBarColor.a = this.hbAlpha;
            this.greenHbBarColor.a = this.hbAlpha;
            this.blueHbBarColor.a = this.hbAlpha;
            this.blockOutlineColor.a = this.hbAlpha;
        }
    }

    protected void gainBlockAnimation() {
        this.blockAnimTimer = 0.7f;
        this.blockTextColor.a = 0.0f;
        this.blockColor.a = 0.0f;
    }

    private void updateBlockAnimations() {
        if (this.currentBlock > 0) {
            if (this.blockAnimTimer > 0.0f) {
                this.blockAnimTimer -= Gdx.graphics.getDeltaTime();
                if (this.blockAnimTimer < 0.0f) {
                    this.blockAnimTimer = 0.0f;
                }
                this.blockOffset = Interpolation.swingOut.apply(BLOCK_OFFSET_DIST * 3.0f, 0.0f, 1.0f - this.blockAnimTimer / 0.7f);
                this.blockScale = Interpolation.pow3In.apply(3.0f, 1.0f, 1.0f - this.blockAnimTimer / 0.7f);
                this.blockColor.a = Interpolation.pow2Out.apply(0.0f, 1.0f, 1.0f - this.blockAnimTimer / 0.7f);
                this.blockTextColor.a = Interpolation.pow5In.apply(0.0f, 1.0f, 1.0f - this.blockAnimTimer / 0.7f);
            } else if (this.blockScale != 1.0f) {
                this.blockScale = MathHelper.scaleLerpSnap(this.blockScale, 1.0f);
            }
            if (this.blockTextColor.r != 1.0f) {
                this.blockTextColor.r = MathHelper.slowColorLerpSnap(this.blockTextColor.r, 1.0f);
            }
            if (this.blockTextColor.g != 1.0f) {
                this.blockTextColor.g = MathHelper.slowColorLerpSnap(this.blockTextColor.g, 1.0f);
            }
            if (this.blockTextColor.b != 1.0f) {
                this.blockTextColor.b = MathHelper.slowColorLerpSnap(this.blockTextColor.b, 1.0f);
            }
        }
    }

    private void updateHbPopInAnimation() {
        if (this.hbShowTimer > 0.0f) {
            this.hbShowTimer -= Gdx.graphics.getDeltaTime();
            if (this.hbShowTimer < 0.0f) {
                this.hbShowTimer = 0.0f;
            }
            this.hbAlpha = Interpolation.fade.apply(0.0f, 1.0f, 1.0f - this.hbShowTimer / 0.7f);
            this.hbYOffset = Interpolation.exp10Out.apply(HB_Y_OFFSET_DIST * 5.0f, 0.0f, 1.0f - this.hbShowTimer / 0.7f);
        }
    }

    private void updateHbDamageAnimation() {
        if (this.healthBarAnimTimer > 0.0f) {
            this.healthBarAnimTimer -= Gdx.graphics.getDeltaTime();
        }
        if (this.healthBarWidth != this.targetHealthBarWidth && this.healthBarAnimTimer <= 0.0f && this.targetHealthBarWidth < this.healthBarWidth) {
            this.healthBarWidth = MathHelper.uiLerpSnap(this.healthBarWidth, this.targetHealthBarWidth);
        }
    }

    public void updatePowers() {
        for (int i = 0; i < this.powers.size(); ++i) {
            this.powers.get(i).update(i);
        }
    }

    public static void initialize() {
        sr = new SkeletonMeshRenderer();
        sr.setPremultipliedAlpha(true);
    }

    public void renderPowerTips(SpriteBatch sb) {
        ArrayList<PowerTip> tips = new ArrayList<PowerTip>();
        if (Settings.POWER_TIP) {
            for (AbstractPower p : this.powers) {
                if (p.region48 != null) {
                    tips.add(new PowerTip(p.name, p.description, p.region48));
                    continue;
                }
                tips.add(new PowerTip(p.name, p.description, p.img));
            }
        }
        if (!tips.isEmpty()) {
            float offsetY = (float)(tips.size() - 1) * MULTI_TIP_Y_OFFSET + TIP_OFFSET_Y;
            if (this.hb.cX + this.hb.width / 2.0f < TIP_X_THRESHOLD) {
                TipHelper.queuePowerTips(this.hb.cX + this.hb.width / 2.0f + TIP_OFFSET_R_X, this.hb.cY + offsetY, tips);
            } else {
                TipHelper.queuePowerTips(this.hb.cX - this.hb.width / 2.0f + TIP_OFFSET_L_X, this.hb.cY + offsetY, tips);
            }
        }
    }

    public void useFastAttackAnimation() {
        this.animX = 0.0f;
        this.animY = 0.0f;
        this.animationTimer = 0.4f;
        this.animation = CreatureAnimation.ATTACK_FAST;
    }

    public void useSlowAttackAnimation() {
        this.animX = 0.0f;
        this.animY = 0.0f;
        this.animationTimer = 1.0f;
        this.animation = CreatureAnimation.ATTACK_SLOW;
    }

    public void useHopAnimation() {
        this.animX = 0.0f;
        this.animY = 0.0f;
        this.vY = 300.0f * Settings.scale;
        this.animationTimer = 0.7f;
        this.animation = CreatureAnimation.HOP;
    }

    public void useJumpAnimation() {
        this.animX = 0.0f;
        this.animY = 0.0f;
        this.vY = 500.0f * Settings.scale;
        this.animationTimer = 0.7f;
        this.animation = CreatureAnimation.JUMP;
    }

    public void useStaggerAnimation() {
        if (this.animY == 0.0f) {
            this.animX = 0.0f;
            this.animationTimer = 0.3f;
            this.animation = CreatureAnimation.STAGGER;
        }
    }

    public void useFastShakeAnimation(float duration) {
        if (this.animY == 0.0f) {
            this.animX = 0.0f;
            this.animationTimer = duration;
            this.animation = CreatureAnimation.FAST_SHAKE;
        }
    }

    public void useShakeAnimation(float duration) {
        if (this.animY == 0.0f) {
            this.animX = 0.0f;
            this.animationTimer = duration;
            this.animation = CreatureAnimation.SHAKE;
        }
    }

    public AbstractPower getPower(String targetID) {
        for (AbstractPower p : this.powers) {
            if (!p.ID.equals(targetID)) continue;
            return p;
        }
        return null;
    }

    public boolean hasPower(String targetID) {
        for (AbstractPower p : this.powers) {
            if (!p.ID.equals(targetID)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeadOrEscaped() {
        if (this.isDying || this.halfDead) {
            return true;
        }
        if (!this.isPlayer) {
            AbstractMonster m = (AbstractMonster)this;
            if (m.isEscaping) {
                return true;
            }
        }
        return false;
    }

    public void loseGold(int goldAmount) {
        if (goldAmount > 0) {
            this.gold -= goldAmount;
            if (this.gold < 0) {
                this.gold = 0;
            }
        } else {
            logger.info("NEGATIVE MONEY???");
        }
    }

    public void gainGold(int amount) {
        if (amount < 0) {
            logger.info("NEGATIVE MONEY???");
        } else {
            this.gold += amount;
        }
    }

    public void renderReticle(SpriteBatch sb) {
        this.reticleRendered = true;
        this.renderReticleCorner(sb, -this.hb.width / 2.0f + this.reticleOffset, this.hb.height / 2.0f - this.reticleOffset, false, false);
        this.renderReticleCorner(sb, this.hb.width / 2.0f - this.reticleOffset, this.hb.height / 2.0f - this.reticleOffset, true, false);
        this.renderReticleCorner(sb, -this.hb.width / 2.0f + this.reticleOffset, -this.hb.height / 2.0f + this.reticleOffset, false, true);
        this.renderReticleCorner(sb, this.hb.width / 2.0f - this.reticleOffset, -this.hb.height / 2.0f + this.reticleOffset, true, true);
    }

    protected void updateReticle() {
        if (this.reticleRendered) {
            this.reticleRendered = false;
            this.reticleAlpha += Gdx.graphics.getDeltaTime() * 3.0f;
            if (this.reticleAlpha > 1.0f) {
                this.reticleAlpha = 1.0f;
            }
            this.reticleAnimTimer += Gdx.graphics.getDeltaTime();
            if (this.reticleAnimTimer > 1.0f) {
                this.reticleAnimTimer = 1.0f;
            }
            this.reticleOffset = Interpolation.elasticOut.apply(RETICLE_OFFSET_DIST, 0.0f, this.reticleAnimTimer);
        } else {
            this.reticleAlpha = 0.0f;
            this.reticleAnimTimer = 0.0f;
            this.reticleOffset = RETICLE_OFFSET_DIST;
        }
    }

    public void renderHealth(SpriteBatch sb) {
        if (Settings.hideCombatElements) {
            return;
        }
        float x = this.hb.cX - this.hb.width / 2.0f;
        float y = this.hb.cY - this.hb.height / 2.0f + this.hbYOffset;
        this.renderHealthBg(sb, x, y);
        if (this.targetHealthBarWidth != 0.0f) {
            this.renderOrangeHealthBar(sb, x, y);
            if (this.hasPower("Poison")) {
                this.renderGreenHealthBar(sb, x, y);
            }
            this.renderRedHealthBar(sb, x, y);
        }
        if (this.currentBlock != 0 && this.hbAlpha != 0.0f) {
            this.renderBlockOutline(sb, x, y);
        }
        this.renderHealthText(sb, y);
        if (this.currentBlock != 0 && this.hbAlpha != 0.0f) {
            this.renderBlockIconAndValue(sb, x, y);
        }
        this.renderPowerIcons(sb, x, y);
    }

    private void renderBlockOutline(SpriteBatch sb, float x, float y) {
        sb.setColor(this.blockOutlineColor);
        sb.setBlendFunction(770, 1);
        sb.draw(ImageMaster.BLOCK_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.BLOCK_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.hb.width, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.BLOCK_BAR_R, x + this.hb.width, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        sb.setBlendFunction(770, 771);
    }

    private void renderBlockIconAndValue(SpriteBatch sb, float x, float y) {
        sb.setColor(this.blockColor);
        sb.draw(ImageMaster.BLOCK_ICON, x + BLOCK_ICON_X - 32.0f, y + BLOCK_ICON_Y - 32.0f + this.blockOffset, 32.0f, 32.0f, 64.0f, 64.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 64, 64, false, false);
        FontHelper.renderFontCentered(sb, FontHelper.blockInfoFont, Integer.toString(this.currentBlock), x + BLOCK_ICON_X, y - 16.0f * Settings.scale, this.blockTextColor, this.blockScale);
    }

    private void renderHealthBg(SpriteBatch sb, float x, float y) {
        sb.setColor(this.hbShadowColor);
        sb.draw(ImageMaster.HB_SHADOW_L, x - HEALTH_BAR_HEIGHT, y - HEALTH_BG_OFFSET_X + 3.0f * Settings.scale, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.HB_SHADOW_B, x, y - HEALTH_BG_OFFSET_X + 3.0f * Settings.scale, this.hb.width, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.HB_SHADOW_R, x + this.hb.width, y - HEALTH_BG_OFFSET_X + 3.0f * Settings.scale, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        sb.setColor(this.hbBgColor);
        if (this.currentHealth != this.maxHealth) {
            sb.draw(ImageMaster.HEALTH_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
            sb.draw(ImageMaster.HEALTH_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.hb.width, HEALTH_BAR_HEIGHT);
            sb.draw(ImageMaster.HEALTH_BAR_R, x + this.hb.width, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        }
    }

    private void renderOrangeHealthBar(SpriteBatch sb, float x, float y) {
        sb.setColor(this.orangeHbBarColor);
        sb.draw(ImageMaster.HEALTH_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.HEALTH_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.healthBarWidth, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.HEALTH_BAR_R, x + this.healthBarWidth, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
    }

    private void renderGreenHealthBar(SpriteBatch sb, float x, float y) {
        sb.setColor(this.greenHbBarColor);
        if (this.currentHealth > 0) {
            sb.draw(ImageMaster.HEALTH_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        }
        sb.draw(ImageMaster.HEALTH_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.targetHealthBarWidth, HEALTH_BAR_HEIGHT);
        sb.draw(ImageMaster.HEALTH_BAR_R, x + this.targetHealthBarWidth, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
    }

    private void renderRedHealthBar(SpriteBatch sb, float x, float y) {
        if (this.currentBlock > 0) {
            sb.setColor(this.blueHbBarColor);
        } else {
            sb.setColor(this.redHbBarColor);
        }
        if (!this.hasPower("Poison")) {
            if (this.currentHealth > 0) {
                sb.draw(ImageMaster.HEALTH_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
            }
            sb.draw(ImageMaster.HEALTH_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.targetHealthBarWidth, HEALTH_BAR_HEIGHT);
            sb.draw(ImageMaster.HEALTH_BAR_R, x + this.targetHealthBarWidth, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
        } else {
            int poisonAmt = this.getPower((String)"Poison").amount;
            if (poisonAmt > 0 && this.hasPower("Intangible")) {
                poisonAmt = 1;
            }
            if (this.currentHealth > poisonAmt) {
                float w = 1.0f - (float)(this.currentHealth - poisonAmt) / (float)this.currentHealth;
                w *= this.targetHealthBarWidth;
                if (this.currentHealth > 0) {
                    sb.draw(ImageMaster.HEALTH_BAR_L, x - HEALTH_BAR_HEIGHT, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
                }
                sb.draw(ImageMaster.HEALTH_BAR_B, x, y + HEALTH_BAR_OFFSET_Y, this.targetHealthBarWidth - w, HEALTH_BAR_HEIGHT);
                sb.draw(ImageMaster.HEALTH_BAR_R, x + this.targetHealthBarWidth - w, y + HEALTH_BAR_OFFSET_Y, HEALTH_BAR_HEIGHT, HEALTH_BAR_HEIGHT);
            }
        }
    }

    private void renderHealthText(SpriteBatch sb, float y) {
        if (this.targetHealthBarWidth != 0.0f) {
            float tmp = this.hbTextColor.a;
            this.hbTextColor.a *= this.healthHideTimer;
            FontHelper.renderFontCentered(sb, FontHelper.healthInfoFont, Integer.toString(this.currentHealth) + "/" + Integer.toString(this.maxHealth), this.hb.cX, y + HEALTH_BAR_OFFSET_Y + HEALTH_TEXT_OFFSET_Y + 5.0f * Settings.scale, this.hbTextColor);
            this.hbTextColor.a = tmp;
        } else {
            FontHelper.renderFontCentered(sb, FontHelper.healthInfoFont, TEXT[0], this.hb.cX, y + HEALTH_BAR_OFFSET_Y + HEALTH_TEXT_OFFSET_Y - 1.0f * Settings.scale, this.hbTextColor);
        }
    }

    private void renderPowerIcons(SpriteBatch sb, float x, float y) {
        float offset = 10.0f * Settings.scale;
        for (AbstractPower p : this.powers) {
            p.renderIcons(sb, x + offset, y - 48.0f * Settings.scale, this.hbTextColor);
            offset += POWER_ICON_PADDING_X;
        }
        offset = 0.0f * Settings.scale;
        for (AbstractPower p : this.powers) {
            p.renderAmount(sb, x + offset + 32.0f * Settings.scale, y - 66.0f * Settings.scale, this.hbTextColor);
            offset += POWER_ICON_PADDING_X;
        }
    }

    private void renderReticleCorner(SpriteBatch sb, float x, float y, boolean flipX, boolean flipY) {
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, this.reticleAlpha / 4.0f));
        sb.draw(ImageMaster.RETICLE_CORNER, this.hb.cX + x - 18.0f + 4.0f * Settings.scale, this.hb.cY + y - 18.0f - 4.0f * Settings.scale, 18.0f, 18.0f, 36.0f, 36.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 36, 36, flipX, flipY);
        sb.setColor(new Color(1.0f, 1.0f, 1.0f, this.reticleAlpha));
        sb.draw(ImageMaster.RETICLE_CORNER, this.hb.cX + x - 18.0f, this.hb.cY + y - 18.0f, 18.0f, 18.0f, 36.0f, 36.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 36, 36, flipX, flipY);
    }

    public abstract void render(SpriteBatch var1);

    static {
        SHAKE_THRESHOLD = Settings.scale * 8.0f;
        SHAKE_SPEED = 150.0f * Settings.scale;
        STAGGER_MOVE_SPEED = 20.0f * Settings.scale;
        RETICLE_OFFSET_DIST = 15.0f * Settings.scale;
    }

    public static enum CreatureAnimation {
        FAST_SHAKE,
        SHAKE,
        ATTACK_FAST,
        ATTACK_SLOW,
        STAGGER,
        HOP,
        JUMP;

    }
}

